'''
    view models for 3ds Max object tree
'''
from PySide2 import QtCore

class vmodelMaxObjects(QtCore.QAbstractItemModel):
    """
    Specialization of a QAbstractItemModel (view) to address the specific
    needs of the 3ds Max object tree
    """
    def __init__(self, root, parent=None, header="Scene objects tree"):
        super(vmodelMaxObjects, self).__init__(parent)
        self._header = header
        self._root = root

    # @override(QtCore.QAbstractItemModel)
    def index(self, row, column, parent):
        '''
        Returns the index of the item in the model specified by the
        given row, column and parent index.
        '''
        index = self.getNode(parent).child(row)
        if index:
            return self.createIndex(row, column, index)
        else:
            return QtCore.QModelIndex()

    def getNode(self, index):
        ''' retrieve the node at the index of the tree '''
        if not index.isValid() or not index.internalPointer():
            return self._root
        return index.internalPointer()

    # @override(QtCore.QAbstractItemModel)
    def columnCount(self, parent):
        ''' Returns the number of columns for the children of the given parent. '''
        return 1

    # @override(QtCore.QAbstractItemModel)
    def rowCount(self, parent):
        ''' Returns the number of rows under the given parent. '''
        parentnode = self._root
        if parent.isValid():
            parentnode = parent.internalPointer()
        return parentnode.numChildren()

    # @override(QtCore.QAbstractItemModel)
    def data(self, index, role):
        ''' Returns the data stored under the DisplayRole for the item referred to by the index. '''
        if index.isValid() and \
           index.internalPointer() and \
           role == QtCore.Qt.DisplayRole and \
           index.column() == 0:
            return index.internalPointer().name

    # @override(QtCore.QAbstractItemModel)
    def setData(self, index, value, role=QtCore.Qt.EditRole):
        ''' Sets the role data for the item at index to value. '''
        if not index.isValid() or not index.internalPointer() and role != QtCore.Qt.EditRole:
            node.setData(index.column(), value)
            self.dataChanged.emit(index, index)
            return True
        return False

    # @override(QtCore.QAbstractItemModel)
    def headerData(self, section, orientation, role):
        '''
        Returns the data for the given role and section in
        the header with the specified orientation.
        '''
        if role == QtCore.Qt.DisplayRole and section == 0:
            return self._header
        return None

    # @override(QtCore.QAbstractItemModel)
    def flags(self, index):
        ''' Returns the item flags for the given index .'''
        return QtCore.Qt.ItemIsEnabled | QtCore.Qt.ItemIsSelectable | QtCore.Qt.ItemIsEditable

    # @override(QtCore.QAbstractItemModel)
    def parent(self, index):
        ''' Returns the parent of the model item with the given index. '''
        parentNode = self.getNode(index).parent
        if parentNode == self._root:
            return QtCore.QModelIndex()
        return self.createIndex(parentNode.row(), 0, parentNode)
